<?php
// Dynamic Sidebar based on user role
$current_page = basename($_SERVER['PHP_SELF']);
$current_path = $_SERVER['REQUEST_URI'];
?>
<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <h2>
            <?php if (!empty(APP_LOGO)): ?>
            <img src="<?php echo htmlspecialchars(APP_LOGO); ?>" alt="Logo" style="max-height: 40px; max-width: 150px; vertical-align: middle; margin-right: 10px;">
            <?php else: ?>
            <i class="fas fa-tint"></i>
            <?php endif; ?>
            <?php echo APP_NAME; ?>
        </h2>
        <small style="color: rgba(255,255,255,0.7); font-size: 0.8rem;">
            <?php echo ucfirst(getUserRole() ?? 'guest'); ?>
        </small>
    </div>
    <nav class="sidebar-nav">
        <a href="<?php echo strpos($current_path, 'admin') !== false || strpos($current_path, 'petugas') !== false || strpos($current_path, 'distribusi') !== false || strpos($current_path, 'prediksi') !== false || strpos($current_path, 'peta') !== false || strpos($current_path, 'laporan') !== false || strpos($current_path, 'notifikasi') !== false ? '../dashboard.php' : 'dashboard.php'; ?>" class="nav-item <?php echo $current_page === 'dashboard.php' ? 'active' : ''; ?>">
            <i class="fas fa-home"></i>
            <span>Dashboard</span>
        </a>
         <a href="<?php echo strpos($current_path, 'admin') !== false || strpos($current_path, 'petugas') !== false || strpos($current_path, 'distribusi') !== false || strpos($current_path, 'prediksi') !== false || strpos($current_path, 'peta') !== false || strpos($current_path, 'laporan') !== false || strpos($current_path, 'notifikasi') !== false ? '../auth/logout.php' : 'auth/logout.php'; ?>" class="nav-item">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </nav>
</aside>